/*------------------------------------------------------------------------------*
 * File Name: GetNPrewDlg	 													*
 * Creation: CPY 1/12/2006														*
 * Purpose: A General GetN dialog with a Graph Preview tab						*
 * Copyright (c) OriginLab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG		*
 *	CPY 10/24/06 XF_DLG_DESTROY_EVENT											*
 *	Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS							*
 * Joseph v8.0646 FIX_BUG_XF_PREVIEW_DIALOG_NO_DESCRIPTION                      *
 *	Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW					*
 *	Sim 07-09-2007 AUTO_PREVIEW_MECHANISM										*
 *	Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON				*
 *	Jasmine 08/28/07 QA80-10311 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME				*
 *	Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	*
 *	Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
 *	Sim 10-10-2009 QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT	*
 *------------------------------------------------------------------------------*/

#ifndef GetNPrevw_H
#define GetNPrevw_H


class GetNPrevwGraphControl : public GraphPageControl
{
public:
	GetNPrevwGraphControl(DWORD dwCntrl) : GraphPageControl(dwCntrl)//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET
	{
	}
	
	virtual bool UpdateGraph(vector* pvx, vector* pvy, vector *pvz, matrix& mat, bool bResetDataSelectTools=false);
	virtual void InitDataPlot(int nPlotType=-1);
	virtual bool GetSelectedDataRange(double& nx, double& ny, double& cx, double& cy);
	//virtual void SetDataSelectToolRange(double dWidth, double dHeight, double dX, double dY);
	virtual void SetDataSelectToolRange(double dleft, double dright, double dtop, double dbottom);
	//virtual bool UpdateGrid(vector* pvx, vector* pvy, double dXStep, double dYStep);
	virtual bool UpdateGrid(double dXMin, double dXMax, double dYMin, double dYMax, double dXStep, double dYStep);
	virtual Matrix& GetMatrix();
	//virtual void SetMatrixXY(double dXMin, double dYMin, double dXMax, double dYMax) {;}
	virtual void ShowTools(bool bShow = true) {;}
	virtual MatrixPage& GetMatrixPage(){return NULL;}
	virtual void SetMatrixPage(MatrixPage& mp) {}
	//---
	virtual void SetWorksheet(Worksheet& wks);
	
	void SetUpdateNeeded(bool bNeeded=true) { m_bUpdateNeeded=bNeeded; }
	bool IsUpdateNeeded() { return m_bUpdateNeeded; }
	
	///DG 7/20/05
	void GetIncludedSize(double &dXMin, double& dXMax, double& dYMin, double& dYMax);
	///end
	
private:
	bool	m_bUpdateNeeded;
	
};

class GetNPrevwDlg : public DynaDlg
{
public:
	///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
	//GetNPrevwDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, int nEventID = XF_GETN_GRAPH, DWORD dwOptions = 0);
	GetNPrevwDlg(int nDlgID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, int nEventID = XF_GETN_GRAPH_OLD, DWORD dwOptions = 0);
	///End ADD_NEW_PREVIEW_DLG_NO_THEME
	~GetNPrevwDlg()
	{
	}
	
	int DoModalEx(HWND hParent);

	int Create(HWND hParent = NULL)	//for development, way to check result
	{
		InitMsgMap();// will be called from internal later
		int nRet = DynaDlg::Create(hParent);
		return nRet;
	}
	
	///Cheney 2006-9-22 MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG
	//virtual
	string GetDlgTitle() {return m_strTitle;}
	///end MOVE_BRANCH_LOADING_AND_SAVING_FROM_DYNABOX_TO_DYNADLG

protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_DESTROY(OnDestroy)
		ON_SIZE(OnDlgResize)
		//ON_OK(OnClickOK)		///DG 9/8/05 : Base on OperationBase, do nothing here
		ON_CANCEL(OnCancel)

//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
		ON_USER_MSG(WM_USER_MSG_BOX, OnMsgBox)
		ON_USER_MSG(WM_USER_MSG_ON_DLG, OnDynamicMsg)
//----
		ON_HELPINFO(OnHelp) //CPY 9/15/06 F1_HELP_WORKS_ON_SIMPLE_GETN_BUT_NOT_ON_PREVIEW_GETN
	

		ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
/*				
		ON_BN_CLICKED(IDC_XYZ_QUICK_PREVIEW_CHK, OnChangePreviewMode)
*/
		ON_USER_MSG(WM_USER_ON_MOVE_LINE, OnMoveLine)
		
		ON_USER_MSG(WM_USER_ON_SET_TAB_TITLES, OnSetBottomTabTitles)
		
		ON_TAB_SEL_CHANGE(IDC_GRAPH_TAB, OnBottomTabChange)
		
		ON_CBN_SELCHANGE(IDC_THEME_COMB, OnComboChangeTheme)
		ON_BN_CLICKED(IDC_SAVE_BTN, OnSaveTheme)
		ON_BN_CLICKED(IDC_SAVE_AS_BTN, OnSaveThemeAs)
		
		ON_GETNDLG_MSGS(IDC_GRID)
		ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	
		ON_DC_GENERIC(OnGenericControlMsg) //---- CPY 8/22/06 Iris found SaveAs button works in DynaBox and not here
		
		/// TD 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		ON_INIT_SIZE(OnInitSize)
		ON_RESTORESIZE(OnRestoreSize)
		/// end DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
		ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN1, OnClickCustomButtom)
		ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN2, OnClickCustomButtom)
		ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN3, OnClickCustomButtom)
		ON_BN_CLICKED(IDC_GETN_CUSTOM_BTN4, OnClickCustomButtom)
		///End GETN_PREVIEW_DLG_NEED_MORE_BTNS
		
		/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
		ON_BN_CLICKED(IDC_APPLY, OnApplyButton)
		/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION

		///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
		ON_BN_CLICKED(IDC_GETN_PREVIEW_BTN, OnPreview)
		ON_BN_CLICKED(IDC_GETN_AUTO_PREVIEW_BTN, OnAutoPreview)
		///---END AUTO_PREVIEW_MECHANISM
		
		/// Iris 02/06/2007 v8.0556 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
		ON_USER_MSG(WM_USER_ON_GRAPH_OBJECT_CHANGE, InvokeGlobalEventOnGraphObjectChange)

		///end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
		
		ON_GETMINMAXINFO(OnMinMaxInfo)	///Joseph 04/11/07 SET_PREVIEW_DLG_MIN_SIZE

	EVENTS_END
///----------------------------------------------
	//---- CPY 10/24/06 XF_DLG_DESTROY_EVENT
protected:
	///---Sim 10-10-2009 QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT
	//virtual 
	void InvokeGlobalEventOnInitDialog();
	///---END QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT
	//virtual 
	void InvokeHandlerOnDestroy(); //---CPY 10/24/06 XF_DLG_DESTROY_EVENT
	//----
	
	BOOL OnInitDialog();
	BOOL OnDestroy();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnClickOK();
	BOOL OnCancel();

	///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
	BOOL OnPreview(Control cntrl);
	BOOL OnAutoPreview(Control cntrl);
	///---END AUTO_PREVIEW_MECHANISM
	///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	///Jasmine 08/28/07 QA80-10311 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	//BOOL OnSaveTheme(Control cntrl);
	//BOOL OnSaveThemeAs(Control cntrl);
	//BOOL LoadTheme(TreeNode& trGetN, string strTheme);
	///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	///End SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
//	BOOL OnChangePreviewMode(Control ctrl);
//	BOOL OnTabChange(Control ctrl);
//	BOOL OnShowBottomPane(Control cntrl);
		
	void OnAfterValueChange(int nRow, int nCol);
	//vritaul
	void OnChangeTheme(const string& strSel, TreeNode& tr);
	void OnMoveLine(uint wParam, uint lParam);

	BOOL OnSelectionChange();
	BOOL OnSelectionTrack();
	
	void SetDialogTitle(LPCSTR lpcszTitle);
	
	int GetBottomPaneSubControls(vector<uint>& vnCntrls);

		//virtual 
	void ResizeDlgControls();//CPY 10/29/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS_SMART_HEIGHT	
	/// TD 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom);
	BOOL OnRestoreSize(DWORD dwSizeInfo);
	bool GetDlgOptimalSize(SIZE& sz);
	/// end DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
	/////Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
	//BOOL OnClickCustomButtom1(Control ctrl);
	//BOOL OnClickCustomButtom2(Control ctrl);
	//BOOL OnClickCustomButtom3(Control ctrl);
	/////End GETN_PREVIEW_DLG_NEED_MORE_BTNS
	//virtual 
	BOOL OnClickCustomButton(int nID);
	//-------- end ADDING_CUSTOM_BUTTON4
	/// Iris 02/06/2007 v8.0556 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	//virtual 
	BOOL 	InvokeGlobalEventOnGraphObjectChange(uint wParam, uint lParam);
	///end CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	///---Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW
	virtual DWORD OnExternalMessage(uint wParam, uint lParam);
	///---END SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW
	
	///Joseph 04/11/07 SET_PREVIEW_DLG_MIN_SIZE
	int	GetTotalHeight(bool bMin = false);
	
	int	GetTotalWidth(bool bMin = false);
	///End SET_PREVIEW_DLG_MIN_SIZE
	
	///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	bool SetAutoPreview(bool bAuto = true);
	
	virtual BOOL OnAfterUpdateDynaControl(uint wParam, uint lParam);
	///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	
	/// YuI 02/22/08 QA80-11156 DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
	BOOL OnApplyButton(Control ctrl);
	/// end DEFAULT_XF_APPLY_BUTTON_IMPLEMENTATION
private:
//	int getBottomGraphIDs(vector<uint> &vnCtrlIDs);
///////////////////////////////////////////////////////////////////////
		
	//void updateBottomTabSize();
	//void updateBottomTabShown(int nShowTab);
	Control& getTabGraphContrl(int nShowTab);
	void resizeTopPaneControl();
	
	bool copyTreeWithoutDataInfo(TreeNode& tr);  /// Iris 3/22/06 THEME_FAIL_WORK_ON_GETN_PREVW_DLG
	
	//void positionQuickPreviewCtrl();
	//bool enableApplyBtn(bool bEnable=true);
	//----- CPY
private:
	void initGraphTabs();
	uint getTabGraphContrlCounts() {return (m_dwCntrl & XFGSETUP_2_TABS)?2:1;} // return 1;}//m_vnTabCntrlItemIDs.GetSize()-1;}// there is a zero termination
	void createGraphControl(GetNPrevwGraphControl* pGraph, int nCntrlID, int nTab);
	void createEMFControl(EMFViewControl* pEMFView, int nCntrlID);		

//	void updateShowBottomPane();
	///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
	//void updateGrid(bool bOnUpdate, bool bTreeChanged = false);
	void updateGrid(bool bOnUpdate, bool bTreeChanged = false, bool bReset = false);
	///------ End PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED

//	PEVENT_FUNC getEventHandler();
	PGRAPH_FUNC getGraphHandler();
	void initAllEvents();
	int invokeHandlers(int nRow, int nCol, int nCntrlType, DWORD nEventInfo);
	
	void updatePreviewOnZoomChange(int nLayerToZoom);	//----- CPY 7/20/06 FFT_FILTERS_ZOOM_RECT_FOR_BETTER_PREVIEW

	//----- CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF
	//GetNPrevwGraphControl&		getGraph(int nGraph);
	/// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
	//DialogViewControl&	getGraph(int nGraph);
	DialogViewControl&	getGraph(int nGraph, bool *pbOK = NULL);
	///end REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
	PictureControl&		getPict();
	void addEMFControl(int nCntrlID, int nIndex);
	void addGraphControl(int nCntrlID, int nIndex);
	//-----
	
	///jasmine 08/06/10 ORG-389 ADD_MATRIX_IMAGE_PREVIEW
	void addMatrixControl(int nCntrlID, int nIndex);
	void createMatrixControl(MatrixViewControl* pMatrixView, int nCntrlID);
	///End ADD_MATRIX_IMAGE_PREVIEW
	
	///Joseph 03/07/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	//get the class option name, for regesty.
	string getDlgName(LPCSTR lpcszDlg);
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	
	///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
	void enablePreviewButton(bool bEnable = true);
	///---END AUTO_PREVIEW_MECHANISM
	///---Sim 11-09-2007 QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	/////Jasmine 08/28/07 QA80-10311 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME	
	//bool addAutoPreviewNode(TreeNode& tr, bool bLoad = true);
	//bool removeAutoPreviewNode(TreeNode& tr);
	/////End SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
	bool controlNodeValueAutoPreview(TreeNode& trGetN, bool& bVal, bool bGetValue);
	bool isAutoPreviewShowed();	
	///---END QA80-10311 QA80-10339 SAVE_AUTO_PREVIEW_CHECKBOX_IN_THEME
private:
	//------ 
///---Sim 07-09-2007 AUTO_PREVIEW_MECHANISM
protected:
	bool m_bAutoPreview;
	Button m_btnPreview;
	Button m_chkAutoPreview;
///---END AUTO_PREVIEW_MECHANISM
private:
//	TreeNode				m_input_tr;
	string					m_strTitle;
	
	///Joseph v8.0646 FIX_BUG_XF_PREVIEW_DIALOG_NO_DESCRIPTION
	//fix bug the xf description is empty.
	//the base class has this member, we set the description to base class member
	//then use this memeber to set the xf description control text.
	//string					m_strDescription;
	///End FIX_BUG_XF_PREVIEW_DIALOG_NO_DESCRIPTION
	
	PGRAPH_FUNC				m_pGraphFunc;
	int						m_nGetNDlgType;
	
//	TabControl				m_tab;
	//----- CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF
	//Array<GetNPrevwGraphControl&>	m_arrGraph;
	Array<DialogViewControl &>	m_arrGraph;
	DWORD					m_dwCntrl;
	//-----
	vector<int>			m_vnTabCntrlItemIDs;
	vector<string>			m_vsTabCntrlGraphTemplates;
	
//	Control						m_txtStatus;
	//Control					m_btnErrMessage;
	
	//temp for init width
	int 					m_nMinWidth; ///Joseph 04/11/07 SET_PREVIEW_DLG_MIN_SIZE
	
	///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	bool m_bUpdateGraph;
	///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	int						m_nDlgID;	//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
};


#endif //GetNPrevw_H
